---
Difficulty: Medium  
Source: Daily-Question (POTD 18-Dec)  
Tags:  
- Array
- Stack
- Monotonic Stack
---


# 🚀 *1475 - Final Prices With a Special Discount in a Shop* 🧠

### Problem Link:
[**LeetCode - Final Prices With a Special Discount in a Shop**](https://leetcode.com/problems/final-prices-with-a-special-discount-in-a-shop/description/?envType=daily-question&envId=2024-12-18)

## 💡 **Problem Breakdown:**

You are given an integer array `prices` where `prices[i]` represents the price of the `i-th` item in a shop.

A **special discount** is applied as follows:
- If you buy the `i-th` item, you receive a discount equal to `prices[j]`, where `j` is the smallest index such that `j > i` and `prices[j] <= prices[i]`.  
- If no such `j` exists, no discount is applied to the `i-th` item.

Return an integer array `answer` where `answer[i]` is the final price you will pay for the `i-th` item, including the special discount.



## 🔍 **Example Walkthrough:**

### Example 1:

**Input:**  
`prices = [8,4,6,2,3]`  
**Output:**  
`[4,2,4,2,3]`  

**Explanation:**  
- For item 0 (`prices[0] = 8`), the discount is `prices[1] = 4`, so final price = `8 - 4 = 4`.  
- For item 1 (`prices[1] = 4`), the discount is `prices[3] = 2`, so final price = `4 - 2 = 2`.  
- For item 2 (`prices[2] = 6`), the discount is `prices[3] = 2`, so final price = `6 - 2 = 4`.  
- Items 3 and 4 have no applicable discounts, so their prices remain the same.



### Example 2:

**Input:**  
`prices = [1,2,3,4,5]`  
**Output:**  
`[1,2,3,4,5]`  

**Explanation:**  
For all items, no discounts are applicable, so the final prices remain the same as the original.



### Example 3:

**Input:**  
`prices = [10,1,1,6]`  
**Output:**  
`[9,0,1,6]`  

**Explanation:**  
- For item 0 (`prices[0] = 10`), the discount is `prices[1] = 1`, so final price = `10 - 1 = 9`.  
- For item 1 (`prices[1] = 1`), the discount is `prices[2] = 1`, so final price = `1 - 1 = 0`.  
- Item 2 (`prices[2] = 1`) has no applicable discount, so its price remains the same.  
- Item 3 (`prices[3] = 6`) has no applicable discount, so its price remains the same.

## 🔍 **Example Walkthrough of Code:**

Let `prices = [8, 4, 6, 2, 3]`.  

### Step-by-Step Execution:

| Iteration | Stack (Indices) | Discounts Applied |
|-----------|-----------------|-------------------|
| `i = 0`   | `[0]`           | No discounts yet |
| `i = 1`   | `[1]`           | Discount for `0`: `8 - 4 = 4` |
| `i = 2`   | `[1, 2]`        | No discounts yet |
| `i = 3`   | `[3]`           | Discounts for `1` and `2`: `4 - 2 = 2`, `6 - 2 = 4` |
| `i = 4`   | `[3, 4]`        | No discounts for `3` or `4` |

**Final Output:** `[4, 2, 4, 2, 3]`.



### Constraints:

- $1 ≤ prices.length ≤ 500$
- $1 ≤ prices[i] ≤ 1000$



## 🎯 **My Approach:**

The problem can be solved efficiently using a **monotonic stack**. Here's how:

1. **Monotonic Stack Idea:**  
   - Traverse the array from left to right, maintaining a stack of indices.  
   - For each element `prices[i]`, check if it can act as a discount for the items represented by the indices in the stack.  
   - While the top of the stack points to an item with a price greater than or equal to `prices[i]`, pop it from the stack and apply the discount.  
   - Push the current index `i` onto the stack for potential discounts for future elements.  

2. **Key Observations:**  
   - The stack ensures we only process each element once, leading to an efficient solution.  
   - The stack is used to keep track of indices where discounts are yet to be applied.  



## 🕒 **Complexity Analysis:**

### **Time Complexity:**  
- **O(n):** Each element is pushed to and popped from the stack at most once, where `n` is the length of the `prices` array.

### **Space Complexity:**  
- **O(n):** Space is used by the stack to store indices.



## 📝 **Solution Code**

## Code (C):

```c
/**
 * Note: The returned array must be malloced, assume caller calls free().
 */
int* finalPrices(int* prices, int pricesSize, int* returnSize) {
    *returnSize = pricesSize;
    int* stack = (int*)malloc(pricesSize * sizeof(int));
    int top = -1; 
    int* result = (int*)malloc(pricesSize * sizeof(int));

    for (int i = 0; i < pricesSize; i++) {
        while (top >= 0 && prices[stack[top]] >= prices[i]) {
            int index = stack[top--];
            prices[index] -= prices[i];
        }
        stack[++top] = i;
    }

    for (int i = 0; i < pricesSize; i++) {
        result[i] = prices[i];
    }

    free(stack);
    return result;
}
```

## Code (C++)

```cpp
class Solution {
public:
    vector<int> finalPrices(vector<int>& prices) {
        vector<int> stack;
        for (int i = 0; i < prices.size(); i++) {
            while (!stack.empty() && prices[stack.back()] >= prices[i]) {
                int index = stack.back();
                stack.pop_back();
                prices[index] -= prices[i];
            }
            stack.push_back(i);
        }
        return prices;
    }
};
```

## Code (Java)

```java
class Solution {
    public int[] finalPrices(int[] prices) {
        int n = prices.length;
        int[] stack = new int[n]; 
        int top = -1; 

        for (int i = 0; i < n; i++) {

            while (top >= 0 && prices[stack[top]] >= prices[i]) {
                int index = stack[top--]; 
                prices[index] -= prices[i];
            }
            stack[++top] = i; 
        }

        return prices;
    }
}
```

## Code (Python)

```python
class Solution:
    def finalPrices(self, prices: List[int]) -> List[int]:
        stack = []
        for i in range(len(prices)):
            while stack and prices[stack[-1]] >= prices[i]:
                index = stack.pop()
                prices[index] -= prices[i]
            stack.append(i)
        return prices
```

## Code (Rust)

```rust
impl Solution {
    pub fn final_prices(prices: Vec<i32>) -> Vec<i32> {
        let mut stack: Vec<usize> = Vec::new();
        let mut result = prices.clone();

        for i in 0..prices.len() {
            while let Some(&index) = stack.last() {
                if prices[index] >= prices[i] {
                    result[index] -= prices[i];
                    stack.pop();
                } else {
                    break;
                }
            }
            stack.push(i);
        }

        result
    }
}
```

## 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
